// auth.js handles login and register form submissions and show/hide password
document.addEventListener('DOMContentLoaded', () => {
  document.querySelectorAll('.toggle').forEach(btn => {
    btn.addEventListener('click', (e) => {
      const input = e.target.closest('label') ? e.target.closest('label').querySelector('input') : null;
      // fallback: find preceding input in password-row
      if (!input) {
        const pr = e.target.parentElement;
        const inp = pr.querySelector('input[type="password"], input[type="text"]');
        if (inp) {
          inp.type = inp.type === 'password' ? 'text' : 'password';
        }
        return;
      }
      input.type = input.type === 'password' ? 'text' : 'password';
    });
  });

  const loginForm = document.getElementById('loginForm');
  if (loginForm) {
    loginForm.addEventListener('submit', async (e) => {
      e.preventDefault();
      const data = new FormData(loginForm);
      const msg = document.getElementById('msg');
      msg.textContent = 'Logging in...';
      try {
        const res = await fetch('php/login.php', { method: 'POST', body: data });
        const json = await res.json();
        if (json.success) {
          msg.style.color = 'green';
          msg.textContent = 'Logged in — redirecting...';
          // redirect to dashboard (PHP session)
          window.location.href = 'php/dashboard.php';
        } else {
          msg.style.color = '#b71c1c';
          msg.textContent = json.error || (json.errors && json.errors.join(' ')) || 'Login failed';
        }
      } catch (err) {
        msg.textContent = 'Network error';
      }
    });
  }

  const registerForm = document.getElementById('registerForm');
  if (registerForm) {
    registerForm.addEventListener('submit', async (e) => {
      e.preventDefault();
      const data = new FormData(registerForm);
      const msg = document.getElementById('msg');
      msg.textContent = 'Creating account...';
      try {
        const res = await fetch('php/register.php', { method: 'POST', body: data });
        const json = await res.json();
        if (json.success) {
          msg.style.color = 'green';
          msg.textContent = 'Registered! Redirecting to login...';
          setTimeout(() => { window.location.href = 'index.html'; }, 1200);
        } else {
          msg.style.color = '#b71c1c';
          msg.textContent = (json.errors && json.errors.join(' ')) || json.error || 'Registration failed';
        }
      } catch (err) {
        msg.textContent = 'Network error';
      }
    });
  }
});
