<?php
require_once 'config.php';
if (empty($_SESSION['user_id'])) {
    header('Location: index.html');
    exit;
}
$user_name = $_SESSION['user_name'];
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Dashboard - Laundry</title>
  <link rel="stylesheet" href="../css/styles.css">
</head>
<body>
  <main class="container">
    <div class="dash-header">
      <a href="logout.php" class="back">&larr; Logout</a>
      <div class="logo-row">
        <img src="../assets/images/WhatsApp Image 2025-11-23 at 7.42.45 AM.jpeg" alt="logo" class="logo">
        <h2>Laundry</h2>
      </div>
    </div>

    <h1>Welcome, <?php echo htmlspecialchars($user_name); ?>!</h1>

    <section class="card">
      <h3>Upcoming Pickup</h3>
      <p>No pickups scheduled yet.</p>
      <button class="primary" onclick="location.href='index.html'">Request Pickup</button>
    </section>

    <section class="card">
      <h3>Quick Actions</h3>
      <ul>
        <li>Request pickup</li>
        <li>View history</li>
        <li>Account settings</li>
      </ul>
    </section>
  </main>
</body>
</html>