<?php
header('Content-Type: application/json; charset=utf-8');
require_once 'config.php';

$identifier = trim($_POST['identifier'] ?? '');
$password = $_POST['password'] ?? '';

if ($identifier === '' || $password === '') {
    echo json_encode(['success' => false, 'error' => 'Identifier and password required.']);
    exit;
}

// try email then phone
$stmt = $conn->prepare('SELECT id, full_name, email, phone, password_hash FROM users WHERE email = ? OR phone = ? LIMIT 1');
$stmt->bind_param('ss', $identifier, $identifier);
$stmt->execute();
$res = $stmt->get_result();
$user = $res->fetch_assoc();
if (!$user) {
    echo json_encode(['success' => false, 'error' => 'Invalid credentials.']);
    exit;
}
if (!password_verify($password, $user['password_hash'])) {
    echo json_encode(['success' => false, 'error' => 'Invalid credentials.']);
    exit;
}

// success: set session
$_SESSION['user_id'] = $user['id'];
$_SESSION['user_name'] = $user['full_name'];

echo json_encode(['success' => true, 'message' => 'Login successful']);
$stmt->close();
$conn->close();
?>