<?php
header('Content-Type: application/json; charset=utf-8');
require_once 'config.php';

$input = $_POST;
$full_name = trim($input['full_name'] ?? '');
$email = trim($input['email'] ?? '');
$phone = trim($input['phone'] ?? '');
$password = $input['password'] ?? '';
$confirm = $input['confirm_password'] ?? '';

$errors = [];
if ($full_name === '') $errors[] = 'Full name is required.';
if ($email === '' && $phone === '') $errors[] = 'Email or phone is required.';
if ($password === '') $errors[] = 'Password is required.';
if ($password !== $confirm) $errors[] = 'Passwords do not match.';

if (!empty($errors)) {
    echo json_encode(['success' => false, 'errors' => $errors]);
    exit;
}

// check unique email or phone
if ($email !== '') {
    $stmt = $conn->prepare('SELECT id FROM users WHERE email = ? LIMIT 1');
    $stmt->bind_param('s', $email);
    $stmt->execute();
    $stmt->store_result();
    if ($stmt->num_rows > 0) {
        echo json_encode(['success' => false, 'errors' => ['Email already registered.']]);
        exit;
    }
    $stmt->close();
}
if ($phone !== '') {
    $stmt = $conn->prepare('SELECT id FROM users WHERE phone = ? LIMIT 1');
    $stmt->bind_param('s', $phone);
    $stmt->execute();
    $stmt->store_result();
    if ($stmt->num_rows > 0) {
        echo json_encode(['success' => false, 'errors' => ['Phone already registered.']]);
        exit;
    }
    $stmt->close();
}

// insert
$hash = password_hash($password, PASSWORD_DEFAULT);
$stmt = $conn->prepare('INSERT INTO users (full_name, email, phone, password_hash) VALUES (?, ?, ?, ?)');
$stmt->bind_param('ssss', $full_name, $email, $phone, $hash);
if ($stmt->execute()) {
    echo json_encode(['success' => true, 'message' => 'Registered successfully']);
} else {
    http_response_code(500);
    echo json_encode(['success' => false, 'errors' => ['Database error']]);
}
$stmt->close();
$conn->close();
?>